-- Entfernt die Rüstzeiten ab der 2. a2_id
SELECT tsystem.function__drop_by_regex( 'ab2__remove__a2_tr__by__ab2s', 'scheduling', _commit => true );
-- https://ci.prodat-sql.de/sources/tests/suite/9/runner/1005
CREATE OR REPLACE FUNCTION scheduling.ab2__remove__a2_tr__by__ab2s(
    IN _a2ids integer[]
    --, IN _remove_starting_from_second bool DEFAULT true
    --, IN _remove_group_by__a2_n bool DEFAULT true -- bei AG Wechsel einmalig Rüsten erhalten > das wird durch die Gruppenbildung in der Oberfläche erreicht, indem man die AG Nr in die Gruppe aufnimmt
    )
    RETURNS void
    AS $$
    DECLARE _rec record;
            _first bool = true;
            -- _a2_n__last varchar = null;
    BEGIN
        FOR _rec IN SELECT a2_id, a2_n, a2_tr_sek, a2_ta, a2_time_stemp, a2_ab_ix
                      FROM ab2
                     WHERE a2_id = ANY(_a2ids)
                     ORDER BY array_position(_a2ids, a2_id) -- die Reihenfolge (kommt aus der Oberfläche) der ids ist entscheiden, was die erste Id ist!
        LOOP
            /*
            -- bei Wechsel AG-Nr wird wieder einmal die Rüstzeit erhalten gelassen
            IF     _a2_n__last IS DISTINCT FROM _rec.a2_n
               AND _remove_group_by__a2_n
            THEN -- TODO: ci-testfall
                _first := true;
            END IF;
            */

            IF _first THEN -- AND _remove_starting_from_second THEN
               _first := false;
            ELSIF NOT _rec.a2_time_stemp > 0 THEN -- Rüstzeit nur abziehen, wenn noch keine Zeitmeldung vorhanden!
               UPDATE ab2_wkstplan SET a2w_stukorr = _rec.a2_ta - _rec.a2_tr_sek / 60 / 60 WHERE a2w_a2_id = _rec.a2_id;
            END IF;

            -- _a2_n__last := _rec.a2_n;

        END LOOP;

        RETURN;
    END $$ LANGUAGE plpgsql;